local delayTime, animSpeed = ... or 0, 0.4
local stripeAmount = 11

local t = Def.ActorFrame{
	Def.Quad {
		InitCommand=function(self)
			self:horizalign(right):vertalign(top):xy(_screen.w,0):zoomto(0,_screen.h):diffuse(LocalBlueColor(0))
		end,
		OnCommand=function(self)
			self:accelerate(animSpeed*1.2):zoomx(_screen.w)
		end
	},
	LoadActor(THEME:GetPathB("_common", "halftone")) .. {
		InitCommand=function(self)
			self:horizalign(right):vertalign(top):xy(_screen.w,0):zoomto(_screen.w,_screen.h):
			customtexturerect(0,0,_screen.w/1024,_screen.h/1024):diffuse(LocalBlueColor(0.25)):cropright(1)
		end,
		OnCommand=function(self)
			self:accelerate(animSpeed*1.2):cropright(0)
		end
	},
}

for i=1, stripeAmount do
	-- todo: merge with _common fancyStill or w/e to save on repetition?
	local theColor = i % 4 == 0 and LocalBlueColor(0.4) or i % 2 == 0 and Color.White or i % 3 == 0 and LocalBlueColor(1) or LocalBlueColor(0.7)
	local heightMod = i % 4 == 0 and 1 or i % 2 == 0 and 0.2 or i % 3 == 0 and 0.5 or 1.5
	local drawOrder = (i % 2 == 0 or i % 3 == 0) and 1 or i % 4 == 0 and 0 or 0.5

	t[#t+1] = Def.Quad {
		InitCommand=function(self)
			self:zoomto(_screen.w*1.2,(_screen.h/stripeAmount)*heightMod):vertalign(top):y((_screen.h / stripeAmount) * (i-1)):horizalign(right):
				x(_screen.w*1.1):rotationz(heightMod*1.2):draworder(drawOrder):cropleft(1)
			self:diffuse(theColor)
		end,
		OnCommand=function(self)
			self:linear(animSpeed + ((i % 3)/10)):cropleft(0)
		end
	}
end

return t
